using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Developed for Locking to share method for all controls.  That's about it.
	/// </summary>
	public class BaseControl : System.Windows.Forms.UserControl
	{
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public BaseControl()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="message"></param>
		public void SpeakMessage(string message)
		{
			
			//
			if ( message != null && message.Length > 0 )
			{
				Common.Utility.Speak( message );
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="listView"></param>
		public void SpeakListViewWithCheckBox(System.Windows.Forms.ListView listView)
		{
			if (listView.SelectedIndices.Count > 0 && Common.LogonUser.IsVisuallyImpairedUser)
			{
				using (new WaitCursor())
				{
					System.Text.StringBuilder buildUserList = new StringBuilder();
					ListViewItem lVI = ((System.Windows.Forms.ListView) listView).SelectedItems[0];
					string[] mySubItems = new string[lVI.SubItems.Count];
					int subCnt = lVI.SubItems.Count;
					int colCnt = listView.Columns.Count;
					int nLoop = 0;
					if(subCnt < colCnt)
					{
						nLoop = subCnt;
					}
					else
					{
						nLoop = colCnt;
					}
					
					for(int nCtr = 0; nCtr < nLoop; nCtr++)
					{
						if(listView.Columns[nCtr].Text.Trim() != string.Empty)
						{
							buildUserList.Append(listView.Columns[nCtr].Text + "coe lin ");
							buildUserList.Append("  ");
						}
						mySubItems[nCtr] = lVI.SubItems[nCtr].Text.Trim();
						if(lVI.SubItems[nCtr].Text.Trim().Length == 0)
						{
							buildUserList.Append("");
						}
						else
						{
							buildUserList.Append(mySubItems[nCtr]);
						}
						buildUserList.Append(" ");
					}
					
					string textToSpeak =buildUserList.ToString();
					
					this.SpeakMessage( textToSpeak );	
				}		
			}
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion


		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		public event EventHandler UserActivity;

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		protected void OnUserActivity()
		{
			try
			{
				if (this.UserActivity != null)
					this.UserActivity(this, System.EventArgs.Empty);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}
	}
}
